/*******************************************************************************
* File:    tb_util.c
* 
* Purpose: Provide commonly used testbench utilities.
* Author:  Quinten Brooks, Freescale Semiconductor MCD IC Design - Phoenix
* Email:   quinten.brooks@freescale.com
* Date:    2007.03.12
*
********************************************************************************
* Notes:
*
*******************************************************************************/

#include "util.h"

// The following variable is used by "flash_control()" to allow single
// constant values to be written into flash.
uint16_t flash_data;


/*******************************************************************************
* The following variable is used to assign values to the flash configuration
* field.  This controls the flash security, protection, and back door access
* features of the flash module.
*******************************************************************************/
#pragma define_section FLASH_CONFIG_BLK ".flscfg" RWX
#pragma section FLASH_CONFIG_BLK begin
const uint16_t flash_config[] = {
   FLASH_CONFIG_0,      // Backdoor Key #1
   FLASH_CONFIG_1,      // Backdoor Key #2
   FLASH_CONFIG_2,      // Backdoor Key #3
   FLASH_CONFIG_3,      // Backdoor Key #4
   FLASH_CONFIG_4,      // Reserved #3
   FLASH_CONFIG_5,      // Reserved #4
   FLASH_CONFIG_6,      // NV Protection Register (NVPROT)
   FLASH_CONFIG_7,      // NV Option Register (NVOPT)
   FLASH_CONFIG_8       // Security
};
#pragma section FLASH_CONFIG_BLK end



/* End of "tb_util.c" */
